﻿# encoding: utf-8
import cgi
import logging

from google.appengine.api import users
from google.appengine.ext import webapp
from google.appengine.ext.webapp.util import run_wsgi_app

class MainPage(webapp.RequestHandler):
  def get(self):
    self.response.out.write("""
		<html>
		<head>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
			<title>Sample</title>
		</head>
		<body>
			<h1>入力した文字をログに出力します</h1>
			<form action="/displayMessage" method="post">
				<input type="text" name="messageData">
				<input type="submit" value="送信">
			</form>
		</body>
		</html>""")

class messageOut(webapp.RequestHandler):
	def post(self):
		usermsg = cgi.escape(self.request.get('messageData'))
		self.response.out.write('<html><head>')
		self.response.out.write('<meta http-equiv="Content-Type" content="text/html; charset=utf-8">')
		self.response.out.write(('</head><body>以下のメッセージをログに出力しました。<br>').decode('utf-8'))
		self.response.out.write(cgi.escape(self.request.get('messageData')))
		self.response.out.write('</body></html>')
		logging.warning(usermsg)

application = webapp.WSGIApplication([('/', MainPage),('/displayMessage', messageOut)],debug=True)

def main():
  run_wsgi_app(application)

if __name__ == "__main__":
  main()